/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter9.timezones;

import java.time.*;
import static java.time.Month.*;
import java.time.format.TextStyle;
import static java.time.temporal.ChronoUnit.HOURS;
import java.time.zone.ZoneRulesProvider;
import java.util.Locale;

/** 
 * @author Matthew Gregory
 */
public class StartHere {
    
    public static void main(String[] args) {
  
        Person me = new Person("Employee","matthew","gregory",Year.of(1971).atMonth(JULY).atDay(28));
        me.timezone=ZoneId.of("Australia/Sydney");
//        System.out.println("Timezone: "+me.timezone);

        //Create the meeting
        Meeting myMeeting = new Meeting(me,LocalDateTime.now().plusDays(7).truncatedTo(HOURS));
        //Create some people for our meeting
        Person myCustomer = new Person("Customer","John","Smith",LocalDate.now().withYear(1998));
        myCustomer.timezone=ZoneId.of("America/New_York");
        Person myCollegue = new Person("Employee","Penny","Chan",LocalDate.now().withYear(1976));
        myCollegue.timezone=ZoneId.of("Australia/Perth");
        //Put them in a list
        Person[] attendees = {myCustomer,myCollegue};
        //assign the people to the meeting
        myMeeting.attendees = attendees;
        //Print out the results
//        myMeeting.displayMeetingDetails();
                
//        System.out.println("Meeting Date: "+myMeeting.meetingDate);
        
        //What is the current timezone and offset of this date?
//        System.out.println("Local Meeting Date "+myMeeting.meetingDate.toLocalDateTime()
//                +" - timezone: "+myMeeting.meetingDate.getZone()
//                +" - offset: "+myMeeting.meetingDate.getOffset());
//        //How is this affected if I add 6 months?
//        ZonedDateTime reviewMeetingDate= myMeeting.meetingDate.plusMonths(6); 
//        System.out.println("Local Review Meeting Date "+reviewMeetingDate.toLocalDateTime()
//                +" - timezone: "+reviewMeetingDate.getZone()
//                +" - offset: "+reviewMeetingDate.getOffset());
        
        //To see what timezone are available
//        for (String zone : ZoneRulesProvider.getAvailableZoneIds()){
//            System.out.println("Zone: "+zone);
//        }

        myMeeting.displayMeetingDate();
    }
}
    
